﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.QT;

namespace MicroRWD.UI.QT
{
    public partial class WriteToTagMemoryForm : Form
    {
        public WriteToMemoryPanel Panel { get { return writeToMemoryPanel; } }

        public WriteToTagMemoryForm()
        {
            InitializeComponent();
        }

        public WriteToTagMemoryForm(int _count, ListView _listView, int _selectedIndex, int _descriptionSubItem, QuadTagReader _reader)
        {
            InitializeComponent();

            Panel.Count = _count;
            Panel.DescriptionSubItem = _descriptionSubItem;
            Panel.ListView = _listView;

            // Read initial tag data
            ReadTagData();
            Panel.ListView.Items[_selectedIndex].Selected = true;
        }

        private void ReadTagData()
        {
            byte[] reply = Program.Controller.Reader.CmdTagRead(Panel.Address);
            if (reply.Length > 0)
            {
                if (reply.Length == Panel.Count + 1)
                {
                    byte[] data = new byte[Panel.Count];
                    for (int i = 0; i < Panel.Count; ++i)
                    {
                        data[i] = reply[i + 1];
                    }
                    Panel.Data = data;
                    Panel.ListView.Items[Panel.Address].SubItems[1].Text = String.Join(string.Empty, Array.ConvertAll(data, b => b.ToString("X2") + ' '));
                    Panel.ListView.Items[Panel.Address].SubItems[2].Text = String.Join(string.Empty, Array.ConvertAll(data, b => ((b > 31) && (b < 127)) ? ((char)b).ToString() + ' ' : ". "));
                }
                else
                {
                    Panel.Data = null;
                    Panel.ListView.Items[Panel.Address].SubItems[1].Text = "<NO DATA>";
                    Panel.ListView.Items[Panel.Address].SubItems[2].Text = "";
                }
            }
            else
            {
                Panel.Data = null;
                Panel.ListView.Items[Panel.Address].SubItems[1].Text = "";
                Panel.ListView.Items[Panel.Address].SubItems[2].Text = "";
            }
        }

        private bool WriteTagData()
        {
            bool result = false;

            // If data is valid
            if (Panel.Data != null)
            {
                // Write to tag
                byte[] reply = Program.Controller.Reader.CmdTagWrite(Panel.Address, Panel.Data);
                if (reply.Length > 0)
                {
                    if (reply.Length == 1)
                    {
                        byte ack = reply[0];

                        if ((ack & 0xFE) == 0xD6)
                        {
                            Panel.ListView.Items[Panel.Address].SubItems[1].Text = String.Join(string.Empty, Array.ConvertAll(Panel.Data, b => b.ToString("X2") + ' '));
                            Panel.ListView.Items[Panel.Address].SubItems[2].Text = String.Join(string.Empty, Array.ConvertAll(Panel.Data, b => ((b > 31) && (b < 127)) ? ((char)b).ToString() + ' ' : ". "));
                            result = true;
                        }
                    }
                }
            }

            return result;
        }

        private void writeToMemoryPanel_Click_CloseButton(object sender, EventArgs e)
        {
            Close();
        }

        private void writeToMemoryPanel_Click_WriteButton(object sender, EventArgs e)
        {
            if (!WriteTagData())
            {
                // Write failed - read current value back
                ReadTagData();
            }


            // Refresh panel
            Panel.Modified = false;
            Panel.UpdateView();
        }

        private void writeToMemoryPanel_Address_Changed(object sender, EventArgs e)
        {
            // Address changed - trigger read
            ReadTagData();

            // Refresh panel
            Panel.Modified = false;
            Panel.UpdateView();
        }
    }
}
